#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Parametrized curvesMod01.fsh   by  sheepmaster
//https://www.shadertoy.com/view/XdXBDH
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float PERIOD = 3.5;

const float RADIUS = 0.8;

const float LINE_WIDTH = 3.;

const int NUM_LINE_SEGMENTS = 50;
const int NUM_NEWTON_ITERATIONS = 0;

const int TILE_MIN = -5;
const int TILE_MAX = 5;

const float PI = 4. * atan(1.);

// Smooth HSV to RGB conversion 
// https://www.shadertoy.com/view/MsS3Wc
vec3 hsv2rgb_smooth(float hue, float saturation, float value) {
    vec3 rgb = clamp(abs(mod(hue*6.0+vec3(0.0,4.0,2.0),6.0)-3.0)-1.0, 0.0, 1.0);

	rgb = rgb*rgb*(3.0-2.0*rgb);  // Cubic smoothing	

	return value * mix(vec3(1.0), rgb, saturation);
}

vec2 curve(float t, float a, float b, float d) {
	return vec2(
        sin(a * t + d) * cos(t + d),
        cos(b * t)     * sin(t + d)
    );
}

vec2 curvePrime(float t, float a, float b, float d) {
    return vec2(
        a * cos(a * t + d) * cos(t + d) -     sin(a * t + d) * sin(t + d),
            cos(b * t)     * cos(t + d) - b * sin(b * t)     * sin(t + d)
    );
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    const int numTiles = TILE_MAX - TILE_MIN + 1;
    
    float minRes = min(iResolution.x, iResolution.y);
    float scale = float(numTiles) / minRes;

    ivec2 tileCoord = ivec2(round((fragCoord - iResolution.xy / 2.) * scale));

	vec2 uv = 2. * fragCoord * scale - 2. * vec2(tileCoord) - iResolution.xy * scale;
    
    // Flip tiles with positive a Y coordinate for symmetry.
    if (tileCoord.y > 0) {
        uv.y = -uv.y;
    }

	float d = (iMouse.w > 0. ? iMouse.y / iResolution.y : iTime / PERIOD) * 2. * PI;
    float hueOffset = (iMouse.w > 0. ? 4. * iMouse.x / iResolution.x : 0.);

    // If the tile coordinates have different parity,
    // only half of the period is needed.
    bool halfPeriod = abs((tileCoord.x * tileCoord.y) % 2) == 1;
	float tPeriod = halfPeriod ? PI : 2. * PI;
    vec2 p1 = curve(0., float(tileCoord.x), float(tileCoord.y), d) * RADIUS;
	float minDist = 1.0;
    float minT;
    float t;
    int numSteps = halfPeriod ? NUM_LINE_SEGMENTS : 2 * NUM_LINE_SEGMENTS;
    for (int i = 1; i <= numSteps; i++) {
        t = float(i) / float(numSteps) * tPeriod;
        vec2 p2 = curve(t, float(tileCoord.x), float(tileCoord.y), d) * RADIUS;

		// Distance to line
        vec2 pa = uv - p2;
        vec2 ba = p1 - p2;

        float h = clamp(dot(pa, ba) / dot(ba, ba), 0.0, 1.0);

        vec2 q = pa - ba * h;

        float dist = dot(q, q);
        if (dist < minDist) {
            minDist = dist;
            minT = (float(i) - h) / float(numSteps) * tPeriod;
        }
        p1 = p2;
    }
    
    t = minT;
    // TODO: This doesn't work well yet
    for (int i = 0; i < NUM_NEWTON_ITERATIONS; i++) {
        vec2 p = curve(t, float(tileCoord.x), float(tileCoord.y), d) * RADIUS;
        vec2 pPrime = curvePrime(t, float(tileCoord.x), float(tileCoord.y), d) * RADIUS;
        vec2 uvp = uv - p;
        float h = dot(uvp, pPrime) / dot(pPrime, pPrime);
        t += h;
        vec2 q = uv - (p + pPrime * h);
        minDist = dot(q, q);
    }

    float hue = fract(hueOffset + t / tPeriod);
//    float dist = length(curve(hue * tPeriod, float(tileCoord.x), float(tileCoord.y), d) * RADIUS - uv);
    
	float v = smoothstep(LINE_WIDTH * scale, 0.0, sqrt(minDist));	
	fragColor = vec4(hsv2rgb_smooth(hue, 1., v), 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

